/*
 * Decompiled with CFR 0.152.
 */
package concurrency;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;

public class Message {
    private Thread sender = Thread.currentThread();
    private String content;
    private boolean repliedTo;
    private static Map<Thread, Queue<Message>> recipientsMap = new HashMap<Thread, Queue<Message>>();

    public Message(String content) {
        this.content = content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Thread destination) throws IllegalArgumentException {
        Queue<Message> recipientQueue;
        if (destination == Thread.currentThread()) {
            throw new IllegalArgumentException("Destination same as sender");
        }
        Object object = recipientsMap;
        synchronized (object) {
            recipientQueue = recipientsMap.get(destination);
            if (recipientQueue == null) {
                recipientQueue = new LinkedList<Message>();
                recipientsMap.put(destination, recipientQueue);
            }
            recipientQueue.add(this);
        }
        object = recipientQueue;
        synchronized (object) {
            recipientQueue.notify();
        }
    }

    public synchronized Message sendAwaitReply(Thread destination) throws IllegalArgumentException {
        this.repliedTo = false;
        this.send(destination);
        boolean replyReceived = false;
        while (!this.repliedTo) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Message receive() {
        Queue<Message> recipientQueue;
        Thread recipient = Thread.currentThread();
        Object object = recipientsMap;
        synchronized (object) {
            recipientQueue = recipientsMap.get(recipient);
            if (recipientQueue == null) {
                recipientQueue = new LinkedList<Message>();
                recipientsMap.put(recipient, recipientQueue);
            }
        }
        object = recipientQueue;
        synchronized (object) {
            while (recipientQueue.size() == 0) {
                try {
                    recipientQueue.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return recipientQueue.poll();
        }
    }

    public synchronized void reply(String replyContent) {
        this.sender = Thread.currentThread();
        this.content = replyContent;
        this.repliedTo = true;
        this.notify();
    }

    public Thread getSender() {
        return this.sender;
    }

    public String getContent() {
        return this.content;
    }

    public String toString() {
        return this.content + " from " + this.sender;
    }
}

