/*
 * Decompiled with CFR 0.152.
 */
package philosophers;

import concurrency.Message;

public class Coordinator
extends Thread
implements Runnable {
    static Coordinator theInstance;

    static Coordinator getInstance() {
        if (theInstance == null) {
            theInstance = new Coordinator();
        }
        return theInstance;
    }

    @Override
    public void run() {
        boolean[] inUse = new boolean[5];
        Message[] waitingMessages = new Message[5];
        while (true) {
            Message message = Message.receive();
            char request = message.getContent().charAt(0);
            char chopstick = message.getContent().charAt(1);
            if (request == 'U') {
                if (inUse[chopstick]) {
                    waitingMessages[chopstick] = message;
                    continue;
                }
                inUse[chopstick] = true;
                message.reply("OK");
                continue;
            }
            Message waitingMessage = waitingMessages[chopstick];
            if (waitingMessage != null) {
                waitingMessages[chopstick] = null;
                waitingMessage.reply("OK");
                continue;
            }
            inUse[chopstick] = false;
        }
    }
}

