/*
 * Decompiled with CFR 0.152.
 */
package philosophers;

import java.awt.Color;
import javax.swing.JLabel;
import philosophers.Chopstick;

public class Philosopher
extends Thread {
    private JLabel label;
    private Chopstick firstChopstick;
    private Chopstick secondChopstick;
    private int state;
    private static final int HUNGRY = 1;
    private static final int EATING = 2;
    private static final int SATED = 3;
    private static final int THINKING = 4;
    private boolean dead;
    private static final int AVERAGE_EAT_TIME = 5000;
    private static final int AVERAGE_THINK_TIME = 5000;

    public Philosopher(JLabel label, Chopstick firstChopstick, Chopstick secondChopstick) {
        this.label = label;
        this.firstChopstick = firstChopstick;
        this.secondChopstick = secondChopstick;
        this.state = 1;
        this.dead = false;
    }

    @Override
    public void run() {
        while (!this.dead) {
            switch (this.state) {
                case 1: {
                    this.label.setForeground(Color.red);
                    this.label.repaint();
                    this.firstChopstick.pickup(this);
                    this.secondChopstick.pickup(this);
                    this.state = 2;
                    break;
                }
                case 2: {
                    this.label.setForeground(Color.green);
                    this.label.repaint();
                    try {
                        Thread.sleep((int)(5000.0 * (0.5 + Math.random())));
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    this.state = 3;
                    break;
                }
                case 3: {
                    this.label.setForeground(Color.yellow);
                    this.label.repaint();
                    this.firstChopstick.putdown();
                    this.secondChopstick.putdown();
                    this.state = 4;
                    break;
                }
                case 4: {
                    this.label.setForeground(Color.blue);
                    this.label.repaint();
                    try {
                        Thread.sleep((int)(5000.0 * (0.5 + Math.random())));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.state = 1;
                }
            }
        }
        this.label.setForeground(Color.black);
        this.label.repaint();
    }

    public void kill() {
        this.dead = true;
        this.interrupt();
    }

    public String name() {
        return this.label.getText();
    }
}

