// $Id: Coefficients.h,v 1.2 2009/06/17 16:28:33 qnet Exp $
//
// Copyright (c) 2009 Jonathan Senning <jonathan.senning@gordon.edu>
// Gordon College, Department of Mathematics and Computer Science
//
// June 10, 2009
//
// Class used to construct the coefficients for the matrix representation
// of a constraint.  Nonzero coefficients are stored consecutively and a
// index vector is used to store the actual matrix row positions.
//
// The column positions for the nonzeros should be specified using the 
// normal mathematical convention where the first index for the row is 1,
// not 0 as C++ (and CPLEX) expects.  When an instance of is class is
// created, however, it must be told whether the solver being used expects
// data indices to start with 1 (as in GLPK) or 0 (as in CPLEX).
//

#ifndef __COEFFICIENTS_H__
#define __COEFFICIENTS_H__

#include <string>
#include <vector>

//----------------------------------------------------------------------------
// Class Coefficients
//----------------------------------------------------------------------------

class Coefficients
{
private:
    std::vector<double> _coef; // nonzero coefficients
    std::vector<int> _index;   // coefficient locations
    int _offset;               // either 0 (for CPLEX) or 1 (for GLPK)
public:
    static const int USING_CPLEX = 0;
    static const int USING_GLPK  = 1;
    Coefficients( int offset = 0 );
   ~Coefficients( void ) { _coef.clear(); _index.clear(); };
    void clear( void );
    void add( int i, double x );
    double* data( void ) { return (double*) &_coef[0]; };
    int* index( void ) { return (int*) &_index[0]; };
    int length( void ) { return _coef.size() - _offset; };
    int offset( void ) { return _offset; };
    std::string toString( std::string sep = " " );
};

#endif // #ifndef __COEFFICIENTS_H__
