// $Id: CommandOptions.h,v 1.2 2009/07/05 19:47:42 senning Exp $
//
// Copyright (c) 2009 Department of Mathematics and Computer Science
// Gordon College, 255 Grapevine Road, Wenham, MA 01984
//
// Author:  Jonathan Senning <jonathan.senning@gordon.edu>
// Written: July 4, 2009
//
// Class to handle command-line options using GNU getopt_long() and allow
// help text to be set for each option.  Both short and long options are
// supported.  A method can be called to display the help text for all
// options.

#ifndef __CommandOptions_h__
#define __CommandOptions_h__

#include <getopt.h>
#include <vector>

class CommandOptions
{
protected:
    static const int DefaultWidth = 35;      // width of options field in output
    std::vector<char> _shortOptions;         // char array for getopt_long()
    std::vector<struct option> _longOptions; // option array for getopt_long()
    std::vector<struct option*> _longOptPtrs;// pointers to option structures
    std::vector<const char*> _description;   // option descriptions
    std::vector<const char*> _argument;      // option arguments
    int _numberOfOptions;                    // number of defined options
    int _flag;                               // holds return value in some cases
    bool _done;                              // true if structure is finalized

public:
    static const int None     = 0;        // option does not have an argument
    static const int Required = 1;        // option has required argument
    static const int Optional = 2;        // option has optional argument
    CommandOptions( void ) { _numberOfOptions = 0; _flag = 0; _done = false; }
    CommandOptions( const CommandOptions& opt );
   ~CommandOptions( void );
    void setOption( const char shortName, const char* longName,
		    const char* desc, const int type = None,
		    const char* argument = NULL );
    void setOption( const int value, const char* longName,
		    const char* desc, const int type = None,
		    const char* argument = NULL );
    void done( void );
    int   getOption( int argc, char* argv[] );
    int   getNumberOfOptions( void ) { return _numberOfOptions; }
    int   getOptionCount( void ) { return optind - 1; }
    int   getOptionError( void ) { return opterr; }
    int   getOptionOpt( void ) { return optopt; }
    char* getOptionArgument( void ) { return optarg; }
    void  quiet( void ) { opterr = 0; }
    void  verbose( void ) { opterr = 1; }
    void  showOptionsHelp( int width = DefaultWidth );
};

#endif // __CommandOptions_h__
