// $Id: SharedLibrary.h,v 1.4 2009/08/04 14:34:34 qnet Exp $
//
// Copyright (c) 2009 Department of Mathematics and Computer Science
// Gordon College, 255 Grapevine Road, Wenham, MA 01984
//
// Author:  Jonathan Senning <jonathan.senning@gordon.edu>
// Written: 2009-06-24
//
// Class to build and dynamically link to a shared library.
// Christopher Pfohl figured out how to do this, all I did was build the
// class.

#ifndef __SHARED_LIBRARY_H__
#define __SHARED_LIBRARY_H__

#include <vector>
#include <string>

class SharedLibrary
{
protected:
    static const int _BufferSize = 256; // max length of file names and commands
    char _srcFileName[_BufferSize];     // source file name
    char _soLibName[_BufferSize];       // name of shared library file
    bool _tmpSrcFile;                   // true if src file is temporary
    void* _handle;                      // library reference pointer

public:
    SharedLibrary( void ) { _handle = NULL; }
    SharedLibrary( const char* srcName, const char* flags = NULL );
    SharedLibrary( std::string srcName, std::string flags = "" );
    SharedLibrary( std::vector<std::string> src, std::string flags = "" );
    SharedLibrary( const SharedLibrary& shlib );
   ~SharedLibrary( void ) {};
    void* getFunction( const char* name );
    void close( void );

private:
    void buildLibrary( const char* flags );
};

#endif // __SHARED_LIBRARY_H__
