// $Id: StatusBar.cc,v 1.2 2009/07/21 16:46:50 senning Exp $
//
// Copyright (c) 2009 Department of Mathematics and Computer Science
// Gordon College, 255 Grapevine Road, Wenham, MA 01984
//
// Author:  Jonathan Senning <jonathan.senning@gordon.edu>
// Written: July 20, 2009
//
// Class to display simple status bar on console.

#include <iostream>
#include "StatusBar.h"

using namespace std;

//-----------------------------------------------------------------------------

// Constructor
//
// Input:
//   string label       - text to display above status bar
//   int num            - width (in characters) of status bar

StatusBar::StatusBar( std::string label, int num )
{
    _label = label;
    _num   = num;
    _count = 0;
}

//-----------------------------------------------------------------------------

// Copy Constructor

StatusBar::StatusBar( StatusBar& bar )
{
    _label = bar._label;
    _num   = bar._num;
    _count = bar._count;
}

//-----------------------------------------------------------------------------

// Method - display status bar header
//
// Input:
//   nothing
// Output:
//   status bar header

void StatusBar::init( void )
{
    cerr << endl << _label << endl;
    cerr << "0%";
    for ( int i = 1; i <= 10; i++ )
    {
	for ( int j = 0; j < _num / 10 - 3; j++ )
	{
	    cerr << ' ';
	}
	cerr << i << "0%";
    }
    cerr << endl;
	
    cerr << '|';
    for ( int i = 1; i <= 10; i++ )
    {
	for ( int j = 0; j < _num / 10 - 1; j++ )
	{
	    cerr << '-';
	}
	cerr << ( i < 10 ? '+' : '|' );
    }
    cerr << endl;
}

//-----------------------------------------------------------------------------

// Method - update status bar
//
// Input:
//   double r    - fraction of bar to display (between 0 and 1)
// Output:
//   updated status bar

void StatusBar::update( double r )
{
    while ( _count <= r * _num )
    {
	_count++;
	cerr << "*";
	cerr.flush();
    }
}

//-----------------------------------------------------------------------------

// Method - finish using status bar
//
// Input:
//   nothing
// Output:
//   completed status bar

void StatusBar::finish( void )
{
    update( 1.0 );
    std::cerr << std::endl;
}

//-----------------------------------------------------------------------------
