// $Id: TaggedValues.h,v 1.3 2009/06/26 16:44:44 qnet Exp $
//
// Copyright (c) 2009 Taylor Carr <taylor.carr@gordon.edu>
// Gordon College, Department of Mathematics and Computer Science
//
// TaggedValues class is heavily modelled after a series of functions written
// by Nathan Walker <nathan.walker@gordon.edu> and extended and maintained
// by Jonathan Senning <jonathan.senning@gordon.edu>.
//
// Date started:  June 15, 2009

#ifndef __TaggedValues_H__
#define __TaggedValues_H__

#include <string>
#include <vector>
#include <map>

/**
 *  Class TaggedValues
**/
class TaggedValues
{
    public:
        
        /******************************METHODS******************************/

        //Create TaggedValues object taking parameters from an input file.
        TaggedValues(const std::string inputFile);

        //Create TaggedValues object taking parameters from a virtual input file
        TaggedValues(const std::vector<std::string> virtualInputFile);
        
        //Copy constructor, creates from an existing TaggedValues object.
        TaggedValues(const TaggedValues& copy);

        //Following two method headers cover the possible values to be read.
        int getParamValue(std::string tag, int defaultValue);
        double getParamValue(std::string tag, double defaultValue);

        //Accessor for returning the virtual input file.
        std::vector<std::string> getVirtualInputFile();

        //Prints all the key and value pairings in the _paramValues map.
        void printParamValues();

        //Prints the _virtualInputFile.  For testing or any other use.
        void printVirtualInputFile();
        
        /*******************************************************************/
        
    private:
    
        /******************************METHODS******************************/
        
        //Removes whitespace (spaces and tabs) and comments from a string.
        std::string collapse(std::string str);
        
        //Enters the parameter name and values as key-value pairings into a map.
        //Pulls from the _virtualInputFile instance variable.
        void fillTaggedValuesMap();
        
        //Returns the value paired with the provided key, tag.  If value isn't
        //found, then the provided defaultValue will be returned.  Will return
        //the value as the same type as the given defaultValue.
        template <class T> T getValue(std::string tag, 
                                      const T& defaultValue);
        
        /*************************INSTANCE VARIABLES************************/
        
        //Vector of strings - each string is a line in the original input file.
        std::vector<std::string> _virtualInputFile;
        
        //Map of param strings keys to Template T values.
        std::map<std::string, std::string> _paramValues;
        
        /*******************************************************************/

};

#endif //__TaggedValues_H__
