#ifndef __DYNARRAY_H__
#define __DYNARRAY_H__

// $Id: dynArray.h,v 1.4 2007/09/28 20:32:55 senning Exp $
//
// Copyright (c) 2007 Jonathan Senning <jonathan.senning@gordon.edu>
// Gordon College, Department of Mathematics and Computer Science
//
// 2007-09-25
//
// These functions can be used to create and destroy multidimensional arrays
// whose dimensions are not known until runtime so that can be passed as
// arguments to functions without the dimensions being known at compile time.

// Define the sizes of some commonly used types

const unsigned int SZbool    = sizeof( bool );
const unsigned int SZchar    = sizeof( char );
const unsigned int SZshort   = sizeof( short );
const unsigned int SZint     = sizeof( int );
const unsigned int SZlong    = sizeof( long int );
const unsigned int SZuchar   = sizeof( unsigned char );
const unsigned int SZushort  = sizeof( unsigned short );
const unsigned int SZuint    = sizeof( unsigned int );
const unsigned int SZulong   = sizeof( unsigned long );
const unsigned int SZfloat   = sizeof( float );
const unsigned int SZdouble  = sizeof( double );
const unsigned int SZldouble = sizeof( long double );

void* allocateArrayV( int datasize, int n, int dim[] );
void  deallocateArrayV( void* p, int n, int dim[] );
void* allocateArray( int datasize, int n, ... );
void  deallocateArray( void* p, int n, ... );

#endif // __DYNARRAY_H__
