#ifndef __QNET_H__
#define __QNET_H__

// $Id: qnet.h,v 1.22 2009/08/03 03:38:11 senning Exp $
//
// Copyright (c) 2007 Jonathan Senning <jonathan.senning@gordon.edu>
// Gordon College, Department of Mathematics and Computer Science
//
// 2007-09-26

#include <string>
#include <getopt.h>       // this can be removed if qnetShortOpts() is removed
#include <dynArray.h>
#include <readTagged.h>

const int QNET_VALUE_ASCII_MAGIC  =  -4;
const int QNET_POLICY_MAGIC       =  -5;
const int QNET_VALUE_MAGIC        =  -7;

const int QNET_NORMAL             =   0;
const int QNET_BAD_MAGIC          = -10;
const int QNET_BAD_DIMENSION      = -11;
const int QNET_BAD_DECISION       = -12;
const int QNET_BAD_NVALUES        = -13;
const int QNET_BAD_TRUNCATION     = -14;
const int QNET_BAD_FILE           = -15;

int* makePolicyArray1D( int ndim, int decn, int dim[] );
double* makeValueArray1D( int ndim, int nval, int dim[] );
void destroyPolicyArray1D( void* p, int ndim, int decn, int dim[] );
void destroyValueArray1D( void* p, int ndim, int nval, int dim[] );

int* makePolicyArray( int ndim, int decn, int dim[] );
double* makeValueArray( int ndim, int nval, int dim[] );
void destroyPolicyArray( void* p, int ndim, int decn, int dim[] );
void destroyValueArray( void* p, int ndim, int nval, int dim[] );

int getPolicyFileInfo( std::string path, int maxdim, int* ndim, int* decn,
		       int dim[] );
int readPolicyFile1D( std::string path, int ndim, int decn, int dim[],
		      void* p );
int writePolicyFile1D( std::string path, int ndim, int decn, int dim[],
		       void* p, char* comment );
int readPolicyFile( std::string path, int ndim, int decn, int dim[], void* p );
int writePolicyFile( std::string path, int ndim, int decn, int dim[], void* p,
		     char* comment );

int getValueFileInfo( std::string path, int maxdim, int* ndim, int* nval,
		      int dim[] );
int readValueFile1D( std::string path, int ndim, int nval, int dim[],
		     void* h );
int writeValueFile1D( std::string path, int ndim, int nval, int dim[],
		      void* h, char* comment );
int readValueFile( std::string path, int ndim, int nval, int dim[], void* h );
int writeValueFile( std::string path, int ndim, int nval, int dim[], void* h,
		    char* comment );

double qnetTimer( void );
void qnetVersion( const char* programNname, const char* revision, 
		  const char* copyright );
char *qnetShortOpts( const struct option* longOpts, char* shortOpts, int n );
void qnetError( int errno, std::string msg );

#endif // __QNET_H__
