// $Id: testALPSdata.cc,v 1.3 2009/07/30 15:01:41 qnet Exp $
//
// Copyright (c) 2009 Taylor Carr <taylor.carr@gordon.edu>
// Gordon College, Department of Mathematics and Computer Science
//
// Date started:  June 12, 2009

#include <iostream>
#include <vector>
#include "ALPSdata.h"


using namespace std;


int main()
{
    cout << endl << "Begin my testing..." << endl << endl;

    vector<string> inputData;
    inputData.push_back("# $Smake: /home/senning/qnet/newhome/bin/detQuadLB %f");
    inputData.push_back("# Number of Classes");
    inputData.push_back("classes = 2");
    inputData.push_back("");
    inputData.push_back("# Number of Machines");
    inputData.push_back("servers = 2");
    inputData.push_back("  ");
    inputData.push_back("# Machine to which each class belongs");
    inputData.push_back("sigma(1) = 1");
    inputData.push_back("sigma(2) = 2");
    inputData.push_back("");
    inputData.push_back("# Arrival rates into each class");
    inputData.push_back("lambda = 1.0");
    inputData.push_back("");
    inputData.push_back("# Holding costs");
    inputData.push_back("c(1) = 1.0");
    inputData.push_back("c(2) = 7.0");
    
    vector<string> paramData;
    paramData.push_back("Q[1,1] = 1");
    paramData.push_back("Q[1,2] = 2");
    paramData.push_back("Q[1,3] = 3");
    paramData.push_back("Q[2,2] = 4");
    paramData.push_back("Q[2,3] = 5");
    paramData.push_back("p[1] = 6");
    paramData.push_back("p[2] = 7");
    paramData.push_back("p[3] = 8");
    
    vector<string> functions;
    functions.push_back("My functions go here");
    functions.push_back("delta/lambda+gibberish");
    functions.push_back("1+100/200**3");
    functions.push_back("a^2 + b^2 = c^2");
    
    
    
    ALPSdata alps(inputData, paramData, "testALPSdata.cc");
    
    alps.writeALPSFile("first.alps");
//    alps.writeFunctionSrcFile("functions.so");
    
//A second object can be correctly made from the writeALPSFile of another.
//    ALPSdata copyalps("first.alps");

//A empty object can be created.
    ALPSdata copyalps;
    
//    copyalps.writeFunctionSrcFile("secondFunctions.so");
    
//    copyalps.writeALPSFile("second.alps");
    
//Manually setting data works.
    copyalps.setInput(alps.getInput());
    
    cout << "-------------------------------" << endl;
    vector<string> testVector = copyalps.getInput();
    vector<string>::iterator iter;
    for(iter = testVector.begin(); iter != testVector.end(); iter++)
    {
        cout << *iter << endl;
    }
    cout << "-------------------------------" << endl;
    
//Test copy constructor
    ALPSdata alps2 = alps;
    
    cout << "-------------------------------" << endl;
    testVector = alps2.getInput();
    for(iter = testVector.begin(); iter != testVector.end(); iter++)
    {
        cout << *iter << endl;
    }
    cout << "-------------------------------" << endl;
    
    
    cout << endl << "Testing est fini!" << endl;

    
    
    return 0;
}
