// $Id: testBasis.cc,v 1.1 2009/07/28 01:44:41 senning Exp $
//
// Copyright (c) 2009 Department of Mathematics and Computer Science
// Gordon College, 255 Grapevine Road, Wenham, MA 01984
//
// Author:  Jonathan Senning <jonathan.senning@gordon.edu>
// Written: July 23, 2009
//
// Demonstrates use of Basis class

#include <iostream>
#include <iomanip>
#include <cstdlib>
#include <TaggedValues.h>
#include <SPNetwork.h>
#include <Basis.h>

int main( int argc, char* argv[] )
{
    using namespace std;

    if ( argc != 2 )
    {
	cerr << "usage: " << argv[0] << " INPUT" << endl;
	exit( EXIT_FAILURE );
    }

    // create network

    TaggedValues input( argv[1] );
    SPNetwork network( input );

    // create a "typical state" and display functions

    cout << endl
	 << "---- Sample state  ----------------------------------------"
	 << endl << endl;

    int numClasses = network.getClasses();
    int x[numClasses + 1];

    cout << "  x = (";
    for ( int i = 1; i <= numClasses; i++ )
    {
	x[i] = i - 1;
	cout << ' ' << x[i];
    }
    cout << " )" << endl;

    // set up basis

    unsigned int mode = Basis::Quadratic | Basis::Linear
	| Basis::PureExp | Basis::MixedExp | Basis::Rational;

    Basis basis( network, mode );
    basis.setRationalTruncation( 30 );

    cout << endl
	 << "---- Using original basis ---------------------------------"
	 << endl << endl;

    if ( basis.hasFunctionType( Basis::Indicator ) )
    {
	cout << "Current basis uses indicator functions" << endl;
	cout << "Indicator truncation = " << basis.getIndicatorTruncation()
	     << endl;
    }
    else
    {
	cout << "Current basis does not use indicator functions" << endl;
    }

    int num = basis.getBasisSize();
    cout << "Number of Basis Functions: " << num << endl;
    for ( int i = 1; i <= num; i++ )
    {
	cout << setw( 4 ) << i << " " << setw( 20 ) << basis.phiString( i )
	     << " = " << basis.phi( i, x ) << endl; 
    }

    // test copy constructor

    cout << endl
	 << "---- Now using copied basis --------------------------------"
	 << endl << endl;

    Basis basis2 = basis;

    mode |= Basis::Indicator;     // add indicator functions
    basis2.setMode( mode );

    // set trucation for indicator functions so that the indicator
    // corresponding to the sample state will be present

    basis2.setIndicatorTruncation( ( numClasses - 1 ) * numClasses / 2 );

    if ( basis2.hasFunctionType( Basis::Indicator ) )
    {
	cout << "Current basis uses indicator functions" << endl;
	cout << "Indicator truncation = " << basis2.getIndicatorTruncation()
	     << endl;
    }
    else
    {
	cout << "Current basis does not use indicator functions" << endl;
    }

    num = basis2.getBasisSize();            // get new basis size
    cout << "Number of Basis Functions: " << num << endl;

    for ( int i = 1; i <= num; i++ )
    {
	cout << setw( 4 ) << i << " " << setw( 20 ) << basis2.phiString( i )
	     << " = " << basis2.phi( i, x ) << endl; 
    }

    return 0;
}
