// $Smake: g++ -Wall -O3 -g -o %F %f CommandOptions.cc
//
// $Id: testCommandOptions.cc,v 1.1 2009/07/04 17:13:51 senning Exp $
//
// Copyright (c) 2009 Department of Mathematics and Computer Science
// Gordon College, 255 Grapevine Road, Wenham, MA 01984
//
// Author:  Jonathan Senning <jonathan.senning@gordon.edu>
// Written: July 4, 2009
//
// Test/example program for CommandOptions class

#include <iostream>
#include <cstdlib>
#include "CommandOptions.h"

using namespace std;

//----------------------------------------------------------------------------

void version( const char* name )
{
    cout << name << " Version 1.0" << endl;
}

//----------------------------------------------------------------------------

void help( const char* name, CommandOptions& options )
{
    cout << "usage: " << name << " [OPTIONS] INPUT" << endl << endl;
    cout << "Description of what this program does goes here and should have"
	 << " lines that" << endl
	 << "fit within the screen boundries.  This is sometimes difficult"
	 << " and makes for" << endl
	 << "rather messy source code." << endl;
    cout << endl << "OPTIONS may be one or more of" << endl;
    options.showOptionsHelp();
}

//----------------------------------------------------------------------------

int main( int argc, char* argv[] )
{
    char* programName = argv[0];

    // Process command line: Build list of options

    enum { ShowHelp, ShowVersion };

    CommandOptions options;

    options.setOption( 's', "server", "server to display data for",
			 CommandOptions::Optional, "SERVER" );
    options.setOption( 'w', "write", "write data to file",
			 CommandOptions::Required, "FILE" );
    options.setOption( 'q', "quiet", "display minimum amount of information" );
    options.setOption( 'v', "verbose", "write out lots of extra information" );
    options.setOption( ShowVersion, "version", "display program version" );
    options.setOption( ShowHelp, "help", "show this help message" );
    options.done();

    // Process all command line options

    int ch;
    while ( ( ch = options.getOption( argc, argv ) ) >= 0 )
    {
	switch ( ch )
	{
	    case 'w':
		cout << "Write data to " << options.getOptionArgument()
		     << endl;
		break;
	    case 's':
		if ( options.getOptionArgument() == NULL )
		    cout << "use default server" << endl;
		else
		    cout << "server is " << atoi( options.getOptionArgument() )
			 << endl;
		break;
	    case 'q':
		cout << "quiet" << endl;
		break;
	    case 'v':
		cout << "verbose" << endl;
		break;
	    case ShowHelp:
		help( programName, options );
		return EXIT_SUCCESS;
	    case ShowVersion:
		version( programName );
		return EXIT_SUCCESS;
		break;
	    case '?':
	    default:
		help( programName, options );
		return EXIT_FAILURE;
	}
    }

    // Now adjust the argument count and pointers to skip over the options
    // we've just processed.

    argc -= options.getOptionCount();
    argv += options.getOptionCount();

    if ( argc < 2 )
    {
	help( programName, options );
	return EXIT_FAILURE;
    }

    cout << "Program name:        " << programName << endl;
    cout << "Remaining arguments:";
    for ( int i = 1; i < argc; i++ )
    {
	cout << ' ' << argv[i]; 
    }
    cout << endl;

    return 0;
}
