// $Id: testDynArray.cc,v 1.2 2008/10/23 20:38:54 senning Exp $
//
// Copyright (c) 2007 Jonathan Senning <jonathan.senning@gordon.edu>
// Gordon College, Department of Mathematics and Computer Science
//
// 2007-09-25

#include <dynArray.h>
#include <iostream>
#include <fstream>
#include <time.h>
using namespace std;

//----------------------------------------------------------------------------

void testDynArray( void )
{
    int n[3] = { 2, 4, 8 };

    // create arrays

    int* a = (int* ) allocateArray( SZint, 1, n[0] );
    float** b = (float**) allocateArray( SZfloat, 2, n[0], n[1] );
    double*** c = (double***) allocateArray( SZdouble, 3, n[0], n[1], n[2] );

    // fill up arrays

    for ( int i = 0; i < n[0]; i++ )
    {
	a[i] = i;
	for ( int j = 0; j < n[1]; j++)
	{
	    b[i][j] = i + 0.1 * j;
	    for ( int k = 0; k < n[2]; k++)
	    {
		c[i][j][k] = 10 * i + j + 0.1 * k;
	    }
	}
    }

    // dump one-dimensional array

    cout << "One-dimensional Array:" << endl;
    for ( int i = 0; i < n[0]; i++ )
    {
	cout << " " << a[i];
    }
    cout << endl;
    cout << endl;

    // dump two-dimensional array

    cout << "Two-dimensional Array:" << endl;
    for ( int i = 0; i < n[0]; i++ )
    {
	for ( int j = 0; j < n[1]; j++ )
	{
	    cout << " " << b[i][j];
	}
	cout << endl;
    }
    cout << endl;

    // dump three-dimensional array

    cout << "Three-dimensional Array:" << endl;
    for ( int i = 0; i < n[0]; i++ )
    {
	for ( int j = 0; j < n[1]; j++ )
	{
	    for ( int k = 0; k < n[2]; k++ )
	    {
		cout << " " << c[i][j][k];
	    }
	    cout << endl;
	}
	cout << endl;
    }
    cout << endl;

    // check for constant stride

    float* b2 = (float*) &b[0][0];
    double* c2 = (double*) &c[0][0][0];

    cout << "Contiguous memory checks" << endl;

    cout << "  Column of two dimensional array:" << endl;
    for ( int i = 0; i < n[0]; i++ )
    {
	int stride = i * n[1];
	cout << "    " << b2[2 + stride] << endl;
    }
    cout << endl;

    cout << "  Vertical column of three-dimensional array:" << endl;
    for ( int i = 0; i < n[0]; i++ )
    {
	int stride = i * n[1] * n[2];
	cout << "    " << c2[12 + stride] << endl;
    }
    cout << endl;

    cout << "  Column of slice of 3-dimensional array:" << endl;
    for ( int i = 0; i < n[1]; i++ )
    {
	int stride = i * n[2];
	cout << "    " << c2[5 + stride] << endl;
    }
    cout << endl;

    // release array memory

    deallocateArray( a, 1, n[0] );
    deallocateArray( b, 2, n[0], n[1] );
    deallocateArray( c, 3, n[0], n[1], n[2] );
}

//----------------------------------------------------------------------------

int main( int argc, char* argv[] )
{
    cout << endl;
    cout << "==== Testing Dynamic Array Routines ";
    cout << "==========================================" << endl;
    cout << endl;

    testDynArray();

    return 0;
}
