// $Id: testMultiIndex.cc,v 1.5 2009/10/02 01:43:07 senning Exp $
//
// $Smake: g++ -Wall -O3 -o %F %f
//
// Copyright (c) 2009 Jonathan Senning <jonathan.senning@gordon.edu>
// Gordon College, Department of Mathematics and Computer Science
//
// February 18, 2009

#include <iostream>
#include <iomanip>
#include "MultiIndex.h"

using namespace std;

#ifdef OLD
int main( void )
{
    int start[]  = { 0, 0, 0 };
    int end[]    = { 3, 4, 5 };
    int stride[] = { 1, 1, 1 };
    MultiIndex Counter1( 3, start, end, stride );
    double h[Counter1.size()];

    cout << "size = " << Counter1.size() << endl;
    for ( int x = Counter1.start(); Counter1.inRange(); x = Counter1.next() )
    {
        h[x] = x;
    }

    MultiIndex Counter2 = Counter1;
//    int del[] = { 1, 2, -1 };

    for ( int u = Counter2.start(); Counter2.inRange(); u = Counter2.next() )
    {
//        int d = Counter2.delta( del );
        cout << "h[" << Counter2.toString( "," ) << "] = " << h[u] << endl;
//        cout << ";  d = " << d << ";  h[u+d] = " << h[u+d] << endl;
    }

    return 0;
}
#endif

//----------------------------------------------------------------------------

void constantMaxLoop()
{
    cout << endl << "-------- Constant maximum value -------"
	 << "---------------------------------------" << endl;

    int dim    = 3;
    int start  = 0;
    int end    = 1;
    int offset = 0;

    cout << "dim = " << dim << "; start = " << start << "; end = " << end;
    cout << "; offset = " << offset << endl;
    cout << endl;

    MultiIndex counter( dim, start, end );
    int* z = counter.getCounterArray( offset );

    for ( int x = counter.start(); counter.inRange(); x = counter.next() )
    {
	for ( int i = offset; i < dim + offset; i++ )
	{
	    cout << " z[" << i << "]=" << z[i];
	}
	cout << " or just " << counter.toString() << endl;
    }
    cout << "---------------------------------------"
	 << "---------------------------------------" << endl << endl;
}

//----------------------------------------------------------------------------

void constantMaxNonzeroOffsetLoop()
{
    cout << endl << "-------- Constant maximum value -------"
	 << "---------------------------------------" << endl;

    int dim    = 3;
    int start  = 0;
    int end    = 1;
    int offset = 1;

    cout << "dim = " << dim << "; start = " << start << "; end = " << end;
    cout << "; offset = " << offset << endl;
    cout << endl;

    MultiIndex counter( dim, start, end );
    int* z = counter.getCounterArray( offset );

    for ( int x = counter.start(); counter.inRange(); x = counter.next() )
    {
	for ( int i = offset; i < dim + offset; i++ )
	{
	    cout << " z[" << i << "]=" << z[i];
	}
	cout << " or just " << counter.toString() << endl;
    }
    cout << "---------------------------------------"
	 << "---------------------------------------" << endl << endl;
}

//----------------------------------------------------------------------------

void varyingMaxLoop()
{
    cout << endl << "-------- Varying maximum values -------"
	 << "---------------------------------------" << endl;

    int dim     = 3;
    int start[] = { 0, 0, 0 };
    int end[]   = { 1, 2, 1 };
    int offset = 0;

    cout << "dim = " << dim << "; start =";
    for ( int i = 0; i < dim; i++ )
    {
	cout << " " << start[i];
    }
    cout << "; end =";
    for ( int i = 0; i < dim; i++ )
    {
	cout << " " << end[i];
    }
    cout << "; offset = " << offset << endl;
    cout << endl;

    MultiIndex counter( dim, start, end );
    int* z = counter.getCounterArray( offset );

    for ( int x = counter.start(); counter.inRange(); x = counter.next() )
    {
	for ( int i = offset; i < dim + offset; i++ )
	{
	    cout << " z[" << i << "]=" << z[i];
	}
	cout << " or just " << counter.toString() << endl;
    }
    cout << "---------------------------------------"
	 << "---------------------------------------" << endl << endl;
}

//----------------------------------------------------------------------------

void varyingMinMaxLoop()
{
    cout << endl << "-------- Varying min and max values ---"
	 << "---------------------------------------" << endl;

    int dim     = 3;
    int start[] = { 5, 0, 3 };
    int end[]   = { 6, 2, 4 };
    int offset  = 0;

    cout << "dim = " << dim << "; start =";
    for ( int i = 0; i < dim; i++ )
    {
	cout << " " << start[i];
    }
    cout << "; end =";
    for ( int i = 0; i < dim; i++ )
    {
	cout << " " << end[i];
    }
    cout << "; offset = " << offset << endl;
    cout << endl;

    MultiIndex counter( dim, start, end );
    int* z = counter.getCounterArray( offset );

    for ( int x = counter.start(); counter.inRange(); x = counter.next() )
    {
	for ( int i = offset; i < dim + offset; i++ )
	{
	    cout << " z[" << i << "]=" << z[i];
	}
	cout << " or just " << counter.toString() << endl;
    }
    cout << "---------------------------------------"
	 << "---------------------------------------" << endl << endl;
}

//----------------------------------------------------------------------------

void varyingMinMaxStrideLoop()
{
    cout << endl << "-------- Varying min,max,stride values "
	 << "---------------------------------------" << endl;

    int dim      = 3;
    int offset   = 0;
    int start[]  = { 2, 0, 0 };
    int end[]    = { 3, 4, 9 };
    int stride[] = { 1, 2, 3 };

    cout << "dim = " << dim << "; start =";
    for ( int i = 0; i < dim; i++ )
    {
	cout << " " << start[i];
    }
    cout << "; end =";
    for ( int i = 0; i < dim; i++ )
    {
	cout << " " << end[i];
    }
    cout << "; stride =";
    for ( int i = 0; i < dim; i++ )
    {
	cout << " " << stride[i];
    }
    cout << "; offset = " << offset << endl;
    cout << endl;

    MultiIndex counter( dim, start, end, stride );
    int* z = counter.getCounterArray( offset );

    for ( int x = counter.start(); counter.inRange(); x = counter.next() )
    {
	for ( int i = offset; i < dim + offset; i++ )
	{
	    cout << " z[" << i << "]=" << z[i];
	}
	cout << " or just " << counter.toString() << endl;
    }
    cout << "---------------------------------------"
	 << "---------------------------------------" << endl << endl;
}

//----------------------------------------------------------------------------

void general()
{
    cout << endl << "-------- Varying min,max,stride values "
	 << "---------------------------------------" << endl;

    int dim      = 3;
    int offset   = 1;
    int start[]  = { 2, 0, 6 };
    int end[]    = { 4, 4, 8 };
    int stride[] = { 1, 1, 1 };

    cout << "dim = " << dim << "; start =";
    for ( int i = 0; i < dim; i++ ) cout << " " << start[i];
    cout << "; end =";
    for ( int i = 0; i < dim; i++ ) cout << " " << end[i];
    cout << "; stride =";
    for ( int i = 0; i < dim; i++ ) cout << " " << stride[i];
    cout << "; offset = " << offset << endl << endl;

    MultiIndex counter( dim, start, end, stride );
    int* z = counter.getCounterArray( offset );

    cout << "Counter extent = " << counter.getCounterExtent() << endl;
    for ( int x = counter.start(); counter.inRange(); x = counter.next() )
    {
	cout << "x = " << setw(4) << x << ";";
	for ( int i = offset; i < dim + offset; i++ )
	{
	    cout << " z[" << setw(2) << i << "] = " << setw( 2 ) << z[i];
	}
	cout << ";    or " << counter.toString() << endl;
    }

    MultiIndex clone = counter;
    int* w = clone.getCounterArray( offset );

    for ( int i = 0; i < dim; i++ )
    {
	start[i]++;
	end[i]--;
    }
    clone.resetBounds( start, end, stride );

    cout << "Clone extent = " << clone.getCounterExtent() << endl;
    for ( int x = clone.start(); clone.inRange(); x = clone.next() )
    {
	cout << "x = " << setw(4) << x << ";";
	for ( int i = offset; i < dim + offset; i++ )
	{
	    cout << " w[" << setw(2) << i << "] = " << setw( 2 ) << w[i];
	}
	cout << ";    or " << clone.toString() << endl;
    }

    cout << "---------------------------------------"
	 << "---------------------------------------" << endl << endl;
}

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------

int main( int argc, char* argv[] )
{
    cout << endl << "==== Testing MultiIndex Class ===="
	 << "==========================================" << endl << endl;

    constantMaxLoop();
    constantMaxNonzeroOffsetLoop();
    varyingMaxLoop();
    varyingMinMaxLoop();
    varyingMinMaxStrideLoop();
    general();

    return 0;
}
