// $Id: testRead.cc,v 1.3 2008/08/04 01:21:45 senning Exp $
//
// Copyright (c) 2007 Jonathan Senning <jonathan.senning@gordon.edu>
// Gordon College, Department of Mathematics and Computer Science
//
// 2007-09-27

#include <iostream>
#include <string>
#include <sstream>
#include <stdlib.h>
using namespace std;
#include "readTagged.h"

//----------------------------------------------------------------------------

template <class T>
inline string toString( const T& t )
// Convert a generic type to a string
// (From http://notfaq.wordpress.com/2006/08/30/c-convert-int-to-string/)
{
    stringstream ss;
    ss << t;
    return ss.str();
}

//--------------------------------------------------------------------------- 

void getInput( string filename, double& lambda, double mu[], double c[],
	       int& N, int& iterMax, double& epsilon )
{
    int iErrVal = -1;
    double dErrVal = -1.0;

    for ( int i = 1; i <= 3; i++ )
    {
	mu[i] = readTagged( filename,
			      string( "mu(" ) + toString( i ) + string( ")" ),
			      dErrVal );
	if ( mu[i] == dErrVal )
	{
	    cerr << "mu[" << i << "] not read; assuming " << mu[i] << endl;
	}
    }

    for ( int i = 1; i <= 3; i++ )
    {
	c[i] = readTagged( filename,
			     string( "c(" ) + toString( i ) + string( ")" ),
			     dErrVal );
	if ( c[i] == dErrVal )
	{
	    cerr << "c[" << i << "] not read; assuming " << c[i] << endl;
	}
    }
   
    lambda = readTagged( filename, string( "lambda" ), dErrVal );
    if ( lambda == dErrVal )
    {
	cerr << "lambda not read; assuming " << lambda << endl;
    }

    N = readTagged( filename, string( "N" ), iErrVal );
    if ( N == iErrVal )
    {
	cerr << "N not read; assuming " << N << endl;
    }

    iterMax = readTagged( filename, string( "iterMax" ), iErrVal );
    if ( iterMax == iErrVal )
    {
	cerr << "iterMax not read; assuming " << iterMax << endl;
    }

    epsilon = readTagged( filename, string( "epsilon" ), dErrVal );
    if ( epsilon == dErrVal )
    {
	cerr << "epsilon not read; assuming " << epsilon << endl;
    }
}

//--------------------------------------------------------------------------- 

void printParameters( double lambda, double mu[], double c[],
	       int N, int iterMax, double epsilon )
{
    cout << "lambda = " << lambda << endl;
    cout << endl;
      
    for ( int i = 1; i <= 3; i++ )
    {
	cout << "c(" << i << ") = " << c[i] << endl;
    }
    cout << endl;
      
    for ( int i = 1; i <= 3; i++ )
    {
	cout << "mu(" << i << ") = " << mu[i] << endl; 
    }
    cout << endl;
   
    cout << "N = " << N << endl;
    cout << "epsilon = " << epsilon << endl;
    cout << "iterMax = " << iterMax << endl;
}

//--------------------------------------------------------------------------- 
//---------------------------------------------------------------------------

int main( int argc, char *argv[] )
{
    const int n = 3;	  // number of classes

    double lambda;        // arrival rate
    double mu[n + 1];     // service rates
    double c[n + 1];      // holding cost

    int N;                // state space truncation
    int iterMax;          // max iterations
    double epsilon;       // error tolerance

    // Read input parameters from file

    if ( argc != 2 )
    {
	cerr << "usage: " << argv[0] << " file" << endl;
	exit( EXIT_FAILURE );
    }

    // get input from file

    getInput( string( argv[1] ), lambda, mu, c, N,iterMax, epsilon );
   
    // display input parameters

    printParameters( lambda, mu, c, N,iterMax, epsilon );
       
    return 0;
}

//--------------------------------------------------------------------------- 

// End of file
