// $Id: testSharedLibrary.cc,v 1.1 2009/06/26 01:34:37 senning Exp $
//
// Copyright (c) 2009 Department of Mathematics and Computer Science
// Gordon College, 255 Grapevine Road, Wenham, MA 01984
//
// Author:  Jonathan Senning <jonathan.senning@gordon.edu>
// Written: 2009-06-25
//
// Demonstrate use of Shared Library class

#include <iostream>
#include <fstream>
#include <cstdlib>
#include <string>
#include <vector>
#include "SharedLibrary.h"

typedef double (*func)( double x );

//-----------------------------------------------------------------------------

void writeSourceFile( std::string fileName )
{
    std::vector<std::string> src;
    src.push_back( "extern \"C\" double sqr(double x)" );
    src.push_back( "{" );
    src.push_back( "    return x*x;" );
    src.push_back( "}" );
    src.push_back( "extern \"C\" double dbl(double x)" );
    src.push_back( "{" );
    src.push_back( "    return x+x;" );
    src.push_back( "}" );

    std::ofstream fout( fileName.c_str() );
    for ( unsigned int i = 0; i < src.size(); i++ )
    {
	fout << src[i] << std::endl;
    }
    fout.close();
}

//-----------------------------------------------------------------------------

int main( int argc, char* argv[] )
{
    using namespace std;

    string fileName( "fcn.cc" );

    writeSourceFile( fileName );

    SharedLibrary lib( fileName );

    func sqr = (func) lib.getFunction( "sqr" );
    if ( sqr == NULL )
    {
	cerr << "Cannot find 'double sqr(double)' in library" << endl;
	return( EXIT_FAILURE );
    }

    func dbl = (func) lib.getFunction( "dbl" );
    if ( dbl == NULL )
    {
	cerr << "Cannot find 'double dbl(double)' in library" << endl;
	exit( EXIT_FAILURE );
    }

    double x = 5.0;
    cout << "x = " << x << "; sqr(x) = " << sqr(x) 
	 << "; dbl(x) = " << dbl(x) << endl;

    lib.close();

    return 0;
}
